﻿///
/// アーカイブの新規作成または更新を行うコントロールクラスのヘッダファイル。
///

#if       !defined(INCLUDED_SZ_ARCHIVE_UPDATER)
#define            INCLUDED_SZ_ARCHIVE_UPDATER

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

#if       !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)
#include  <szForwardDeclarations.hpp>
#endif // !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)

SZ_NS_BEG(szpp)

struct SZ_SPEC ArchiveUpdaterOptions
{
  ArchiveUpdaterOptions();

  szstring ArchiveType;
  szstring Method;
  szstring Level;
  szstring Solid;
  szstring Password;
  szstring EncryptionMethod;
  bool Sfx;
  bool EncryptNames;
};

/// <summary>
/// アーカイブの新規作成または更新を行うクラス。
/// </summary>
class SZ_SPEC ArchiveUpdater
{
public:

  /// <summary>
  /// CodecManager から呼ばれるコンストラクタ。
  /// </summary>
  //ArchiveUpdater(/*const ArchiveFormat &format*/);
  /// <summary>
  /// デストラクタ。
  /// </summary>
~ArchiveUpdater();

  /// <summary>
  /// ファイルアーカイブをフォルダに簡易展開するための静的メソッドで、epolight のような簡易アプリが使用することを想定している。
  /// </summary>
  /// <param name="archivePath">展開するアーカイブファイルのパス文字列。</param>
  /// <param name="outputDir">展開先ディレクトリのパス文字列。ディレクトリ自動作成をするなら、自動作成するディレクトリ名も含んだ形で渡すこと。</param>
  /// <param name="options">圧縮オプション。必要がなければ NULL を与えてもよい。</param>
  /// <param name="openCallback">アーカイブを開く際の進行状況などを受け取るクライアントコールバックのポインタ。</param>
  /// <param name="extractCallback">アーカイブを展開する際の進行状況などを受け取るクライアントコールバックのポインタ。</param>
  /// <param name="pwdCallback">ユーザーからパスワードを取得するためのクライアントコールバックのポインタ。</param>
  static void Update(
    const std::vector<szstring> &paths,
    const szstring &archivePath,
    const ArchiveUpdaterOptions *options,
    ArchiveOpenClientCallback *openCallback,
    ArchiveFileUpdateClientCallback *updCallback,
    GetPasswordClientCallback *pwdCallback);

};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_ARCHIVE_UPDATER)
